#include <SFML/Graphics.hpp>  
#include <iostream>
#include "Spielfeld.h"
#include "../../kap7/fonts.h"      // ArialFontDatei
constexpr const std::size_t sizeXY = 600; // Fensterbreite

int main() {
  sf::RenderWindow window(sf::VideoMode(sizeXY, 
                      sizeXY + 80),  // + 80: Bereich für Text
                      "TicTacToe");  // Titel
  std::size_t aktiverSpieler = 1;
  std::size_t besetzteFelder = 0;
  bool feldmarkiert = false;
  bool spielbeendet = false;
  Spielfeld spielfeld(window);
  sf::Font font;
  if (!font.loadFromFile(ArialFontDatei)) {
    std::cerr << "Font nicht gefunden\n";
  }
  sf::Text text("Spieler 1 ist dran", font, 40);
  text.setColor(sf::Color::Black);
  text.setPosition(10, sizeXY);
  while (window.isOpen()) {
    sf::Event event;
    while (window.pollEvent(event)) {
      switch(event.type) {
         case sf::Event::Closed : window.close(); 
           break;
         case sf::Event::MouseButtonPressed: 
           if(!spielbeendet) {
             feldmarkiert = spielfeld.markierungSetzen(
                                 aktiverSpieler,
                                 event.mouseButton.x, 
                                 event.mouseButton.y);
           }
           break;
         default: ; // nichts tun
      }
    }
    if(feldmarkiert && !spielbeendet) {
      feldmarkiert = false;
      ++besetzteFelder;
      if (spielfeld.gewonnen()) {
        text.setString("Spieler " 
                       + std::to_string(aktiverSpieler) 
                       +  " gewinnt! - Ende");
        spielbeendet = true;
      }
      else {
        if(besetzteFelder == 9) {
          text.setString("Unentschieden!");
        }
        else {
          aktiverSpieler = (aktiverSpieler % 2) + 1;
          text.setString("Spieler " 
                      + std::to_string(aktiverSpieler) 
                      + " ist dran");
        }
      }
    }
    window.clear(sf::Color::White); 
    // hier alles zeichnen:
    window.draw(spielfeld);
    window.draw(text);
    window.display();
  }
}
