#ifndef SPIELFELD_H
#define SPIELFELD_H
#include <array>
#include <SFML/Graphics.hpp>  
using TTTarray
   = std::array<std::array<sf::RectangleShape, 3>, 3>;

class Spielfeld : public sf::Drawable {
public:
  Spielfeld(sf::RenderWindow& window);

  bool  markierungSetzen(size_t aktiverSpieler, 
                    int x, int y); // angeklickte Koordinate

  bool gewonnen() const;

  virtual void draw(sf::RenderTarget& window, 
                    sf::RenderStates states) const {
    for(const auto& zeile : quadrate) {
      for(const auto& quadrat : zeile) {
        window.draw(quadrat);
      }
    }
  }
private:
  TTTarray quadrate;
};
#endif

