#include "Spielfeld.h"
#include <cassert>

namespace {
// Farben festlegen
const sf::Color frei = sf::Color::White;
const sf::Color spieler1 = sf::Color::Green;
const sf::Color spieler2 = sf::Color::Red;

  bool zeileMitGleichenWerten(size_t z, const TTTarray& m) {
    assert(m.size() == 3);  // ggf. Funktion anpassen!
    return m[z][0].getFillColor() != frei 
      && m[z][0].getFillColor() == m[z][1].getFillColor()
      && m[z][1].getFillColor() == m[z][2].getFillColor();
  }

  bool spalteMitGleichenWerten(size_t s, const TTTarray& m) {
    assert(m.size() == 3);  // ggf. Funktion anpassen!
    return m[0][s].getFillColor() != frei
      && m[0][s].getFillColor() == m[1][s].getFillColor() 
      && m[1][s].getFillColor() == m[2][s].getFillColor();
  }

  bool diagonaleMitGleichenWerten(const TTTarray& m) {
    assert(m.size() == 3);  // ggf. Funktion anpassen!
    // von links oben nach rechts unten
    return (m[0][0].getFillColor() != frei
            && m[0][0].getFillColor() == m[1][1].getFillColor() 
            && m[1][1].getFillColor() == m[2][2].getFillColor()) 
      ||     // oder: von links unten nach rechts oben
      (m[2][0].getFillColor() != frei
       && m[2][0].getFillColor() == m[1][1].getFillColor() 
       && m[1][1].getFillColor() == m[0][2].getFillColor());
  }
}

Spielfeld::Spielfeld(sf::RenderWindow& window) {
  std::size_t laenge =  window.getView().getSize().x/quadrate.size();
  // \tts{ quadrate.size()} = Anzahl der Zeilen
  for(std::size_t i = 0u; i < quadrate.size(); ++i) {
    // \tts{ quadrate[0].size()} = Anzahl der Spalten
    for(std::size_t j = 0u; j < quadrate[0].size(); ++j) {
      quadrate[i][j] = sf::RectangleShape(
                              sf::Vector2f(laenge, laenge));
      quadrate[i][j].setFillColor(frei);
      quadrate[i][j].setOutlineColor(sf::Color::Black);
      quadrate[i][j].setOutlineThickness(2);
      quadrate[i][j].setPosition(j*laenge,i*laenge);
    }
  }
}

  bool  Spielfeld::markierungSetzen(size_t aktiverSpieler, 
int x, int y) {
    bool markiert = false;
    sf::Vector2f pos(x, y);
    for(std::size_t i = 0u; i < quadrate.size() && !markiert; ++i) {
      for(std::size_t j = 0u; j < quadrate[0].size() && !markiert; ++j) {
        // getGlobalBounds() gibt ein Rechteck zurück, das quadrate[i][j]
        // umfasst. contains(pos) gibt an, ob die Position darin liegt.
        if (quadrate[i][j].getGlobalBounds().contains(pos)) {
          if(quadrate[i][j].getFillColor() == frei) {
            if(aktiverSpieler == 1) {
              quadrate[i][j].setFillColor(spieler1);
            }
            else {
              quadrate[i][j].setFillColor(spieler2);
            }
            markiert = true;
          }
        }
      }
    }
    return markiert;
  }

bool Spielfeld::gewonnen() const {
  for (std::size_t z = 0; z < quadrate.size(); ++z) { // alle Zeilen
    if (zeileMitGleichenWerten(z, quadrate)) {   //  gefunden
      return true;   // weitere Tests unnötig
    }
  }
  for (std::size_t s = 0; s < quadrate.size(); ++s) { // alle Spalten
    if (spalteMitGleichenWerten(s, quadrate)) {  // gefunden
      return true;   // weitere Tests unnötig
    }
  }
  return diagonaleMitGleichenWerten(quadrate);
}


