#ifndef GRAPHOBJEKT_H
#define GRAPHOBJEKT_H
#include <iostream>
#include "Punkt.h"

class GraphObjekt {
public:
  GraphObjekt(Punkt p = {}) 
    : punkt(p) {
  }
  virtual void zeichnen() const = 0;
  virtual Punkt bezugspunkt() const final {
    return punkt;
  }
  virtual ~GraphObjekt() = default;
  GraphObjekt(const GraphObjekt&) = default;
  GraphObjekt& operator=(const GraphObjekt&) = default;
private:
  Punkt punkt;
};

inline void GraphObjekt::zeichnen() const {
  std::cout << "GraphObjekt zeichnen bei ("
            << punkt.x << ", " << punkt.y << ")\n";
}

#endif
