#include <cstddef>
#include <iostream>
#include <random>
#include <vector>
#include "Raketentest.h"

namespace {
  std::random_device rd;
  std::mt19937 generator(rd());
  std::vector<Rakete> zuzeichnen;
  std::size_t maxsize = 0;
  std::size_t ersteSichtbare = 0;
}

Raketentest::Raketentest()
: fenster(sf::VideoMode(sizeX, sizeY), "Leertaste druecken gibt Raketenschwarm"),
  periode(sf::milliseconds(25)) {
    fenster.setKeyRepeatEnabled(false);
}

void Raketentest::run() {
  while (fenster.isOpen()) { // Hauptschleife
    dauer = stoppuhr.getElapsedTime();
    ereignisseVerarbeiten();
    if (dauer >= periode) {
      stoppuhr.restart();
      fenster.clear(sf::Color::White); // Vor dem Zeichnen löschen
      for(std::size_t i = ersteSichtbare; i < zuzeichnen.size(); ++i) {
        zuzeichnen[i].aktualisierePosition(fenster);
        if(zuzeichnen[i].sichtbar()) {
          zuzeichnen[i].aendereGeschwindigkeit(0.0f, -0.05f);
          fenster.draw(zuzeichnen[i].asSFMLdrawable());
        }
        else {  // mit Platz ersteSichtbare vertauschen
            auto temp = zuzeichnen[ersteSichtbare];
            zuzeichnen[ersteSichtbare] = zuzeichnen[i];
            zuzeichnen[i] = temp;
            ++ersteSichtbare;
        }
      }
    }
    fenster.display();
  }
}

void Raketentest::ereignisseVerarbeiten() {
  sf::Event event;
  while (fenster.pollEvent(event)) {
    switch (event.type) {
       case sf::Event::Closed: fenster.close();
         break;
       case sf::Event::KeyPressed:
         if (event.key.code == sf::Keyboard::Space) {
           std::uniform_real_distribution<float> verteilung(3.0f, 10.0f); 
           float vx =  verteilung(generator);
           float vy =  verteilung(generator);
           if(ersteSichtbare == 0) {   // kein freier Platz
             zuzeichnen.push_back(Rakete(70, sizeY-80, vx, vy));
           }
           else { // recyceln, d.h. Objekt neu verwenden
             zuzeichnen[--ersteSichtbare].reset(70, sizeY-80, vx, vy);
           }
           if(maxsize < zuzeichnen.size()) {
             maxsize = zuzeichnen.size();
             std::cout << "neue Vektorgröße = " << maxsize << '\n';
           }
         }
         break;
       default: // nichts tun
         break;
    }
  }
}


