#include <memory>
#include <random>
#include <vector>
#include "Raketentest.h"

namespace {
  std::random_device rd;
  std::mt19937 generator(rd());
  std::vector<std::unique_ptr<Rakete> > zuzeichnen;
}

Raketentest::Raketentest()
: fenster(sf::VideoMode(sizeX, sizeY), "Leertaste druecken gibt Raketenschwarm"),
  periode(sf::milliseconds(25)) {
    fenster.setKeyRepeatEnabled(false);
}

void Raketentest::run() {
  while (fenster.isOpen()) { // Hauptschleife
    dauer = stoppuhr.getElapsedTime();
    ereignisseVerarbeiten();
    if (dauer >= periode) {
      stoppuhr.restart();
      // Vor dem Zeichnen alles löschen:
      fenster.clear(sf::Color::White);
      for (auto& rakete : zuzeichnen) {
        if(rakete->sichtbar()) {
          rakete->aktualisierePosition(fenster);
          rakete->aendereGeschwindigkeit(0.0f, -0.05f);
          fenster.draw(rakete->asSFMLdrawable());
        }
      }
    }
    fenster.display();
  }
}

void Raketentest::ereignisseVerarbeiten() {
  sf::Event event;
  while (fenster.pollEvent(event)) {
    switch (event.type) {
       case sf::Event::Closed: fenster.close();
         break;
       case sf::Event::KeyPressed:         // neu
         if (event.key.code == sf::Keyboard::Space) {
           std::uniform_real_distribution<float> verteilung(3.0f, 10.0f); 
             zuzeichnen.push_back(
                  std::make_unique<Rakete>(70, sizeY-80,
                                verteilung(generator),      // vx
                                verteilung(generator)));    // vy
         }
         break;
       default: // nichts tun
         break;
    }
  }
}


