#ifndef RAKETE_H
#define	RAKETE_H
#include <SFML/Graphics.hpp>  
#include <cmath>

class Rakete {
public:
  Rakete(float x, float y, float vX, float vY)
    : fuenfeck(5) {
    reset(x, y, vX, vY);
    float b = 20.0;                // Breite
    float h = 80;                  // Höhe
    fuenfeck.setPoint(0, sf::Vector2f(0, h));
    fuenfeck.setPoint(1, sf::Vector2f(b, h));
    fuenfeck.setPoint(2, sf::Vector2f(b, b));
    fuenfeck.setPoint(3, sf::Vector2f(b/2, 0));
    fuenfeck.setPoint(4, sf::Vector2f(0, b));
    fuenfeck.setFillColor(sf::Color::Red);
    fuenfeck.setOutlineColor(sf::Color::Black);
    fuenfeck.setOutlineThickness(2);
  }

  void reset(float x, float y, float vX, float vY) {
    fuenfeck.setPosition(x, y);
    vx = vX;
    vy = vY;
    fuenfeck.setRotation(std::atan2(vx, vy)
                       *180/3.1415926f);  // 45 Grad bei vx==vy
    istsichtbar = true;
  }

  sf::Vector2f getPosition() const {
    return fuenfeck.getPosition();
  }

  const sf::ConvexShape& asSFMLdrawable() const {
    return fuenfeck;
  }

  void aktualisierePosition(const sf::RenderWindow& w) {
    if(istsichtbar 
       && fuenfeck.getPosition().x <  w.getSize().x + 60
       && fuenfeck.getPosition().y <  w.getSize().y + 60
       && fuenfeck.getPosition().y >  -60) {
      fuenfeck.move(vx, -vy);
    }
    else {     // außerhalb des Fensters
      istsichtbar = false;
    }
  }

  void aendereGeschwindigkeit(float dvx, float dvy) {
    vx += dvx;
    vy += dvy;
    fuenfeck.setRotation(std::atan2(vx, vy)
                         *180/3.1415926f);  // 45 Grad bei vx==vy
  }
  bool sichtbar() const {
    return istsichtbar;
  }
  void sichtbar(bool s) {
    istsichtbar = s;
  }
private:
  float vx;
  float vy;
  sf::ConvexShape fuenfeck;
  bool istsichtbar;
};

#endif	

