#ifndef RAKETE_H
#define	RAKETE_H
#include <SFML/Graphics.hpp>  
#include <cmath>                     // wegen \tts{atan2()}

// Umrechnungsfaktor Bogenmaß -> Winkel
constexpr float b2w {180.0f/3.1415926f};

class Rakete {
public:
  Rakete(float x, float y, float vx_, float vy_)
  : vx(vx_), vy(vy_), fuenfeck(5) {
    float b = 20.0;                  // Breite
    float h = 80.0;                  // Höhe
    fuenfeck.setPoint(0, sf::Vector2f(0, h));
    fuenfeck.setPoint(1, sf::Vector2f(b, h));
    fuenfeck.setPoint(2, sf::Vector2f(b, b));
    fuenfeck.setPoint(3, sf::Vector2f(b/2, 0));
    fuenfeck.setPoint(4, sf::Vector2f(0, b));
    fuenfeck.setFillColor(sf::Color::Red);
    fuenfeck.setOutlineColor(sf::Color::Black);
    fuenfeck.setOutlineThickness(2);
    fuenfeck.setRotation(std::atan2(vx, vy)*b2w);
                              // d.h. 45 Grad bei \tts{vx==vy}
    fuenfeck.setPosition(x, y);
  }

  sf::Vector2f position() const {
    return fuenfeck.getPosition();
  }

  const sf::ConvexShape& asSFMLdrawable() const {
    return fuenfeck;
  }

  void aktualisierePosition() {
    fuenfeck.move(vx, -vy);
  }

  void aendereGeschwindigkeit(float dvx, float dvy) {
    vx += dvx;
    vy += dvy;
    fuenfeck.setRotation(std::atan2(vx, vy)*b2w);  
                              // d.h. 45 Grad bei \tts{vx==vy}
  }
private:
  float vx;
  float vy;
  sf::ConvexShape fuenfeck;
};
#endif	

