#include "Feuerwerk.h"

Feuerwerk::Feuerwerk()
: fenster(sf::VideoMode(sizeX, sizeY), "Das Fenster!"),
  feuerball(30), rakete(70, sizeY - 80, 8.0, 8.0),
  zustand(Zustand::Anfang) {
    periode = sf::milliseconds(25);
}

void Feuerwerk::run() {
  while (fenster.isOpen()) { // Hauptschleife
    dauer = stoppuhr.getElapsedTime();
    ereignisseVerarbeiten();
    if (dauer >= periode) {
      stoppuhr.restart();
      fenster.clear(sf::Color::White); // Vor dem Zeichnen löschen

      switch (zustand) {
        case Zustand::Anfang: // vorbereitende Maßnahmen
          feuerball.setFillColor(sf::Color::Yellow);
          zustand = Zustand::Flug; // neuer Zustand
          break;
        case Zustand::Flug:
          if (rakete.position().x < sizeX*0.7
                  && rakete.position().y > sizeY*0.3) {
            rakete.aktualisierePosition();
            rakete.aendereGeschwindigkeit(0.0f, -0.1f);
            fenster.draw(rakete.asSFMLdrawable());
          } else {
            feuerball.setPosition(rakete.position());
            zustand = Zustand::Knall;
          }
          break;
        case Zustand::Knall:
        {
          float radius = feuerball.getRadius();
          if (radius <= sizeY / 3) {
            const float delta = 10.0f;
            radius += delta; // aufblähen
            feuerball.setRadius(radius);
            feuerball.move(-delta, -delta);
            fenster.draw(feuerball);
          } else { // Endstadium erreicht
            zustand = Zustand::Ende;
          }
        }
          break;
        case Zustand::Ende:
          // Kreis wird unsichtbar:
          feuerball.setFillColor(sf::Color::White);
          fenster.draw(feuerball);
          break;
        default:; // nichts tun, darf hier nicht vorkommen
      }
    }
    fenster.display();
  }
}

void Feuerwerk::ereignisseVerarbeiten() {
  sf::Event event;
  while (fenster.pollEvent(event)) {
    switch (event.type) {
      case sf::Event::Closed: fenster.close();
        break;
        // weitere Möglichkeiten weggelassen
      default: // nichts tun
        break;
    }
  }
}


