#include <SFML/Graphics.hpp>  
#include <iostream>
#include "fonts.h"      // ArialFontDatei

int main() {
   constexpr int sizeX = 800;           // Fenstergröße
   constexpr int sizeY = 600;
   sf::RenderWindow window(sf::VideoMode(sizeX, sizeY),
                           "Das Fenster!");  // Titel
   sf::CircleShape kreis(100);
   kreis.setFillColor(sf::Color(255, 0, 0, 100)); 
                  // r g b (alpha=255). Siehe Text
   float x = 0.0;
   float y = sizeY - 2 * kreis.getRadius();
   kreis.setPosition(x, y); 
   sf::Font font;
   if (!font.loadFromFile(ArialFontDatei)) {
      std::cerr << "Font nicht gefunden\n";
   }
   sf::Text text("Hello", font, 80);
   text.setFillColor(sf::Color::Black);
   text.setPosition(x + 2 * kreis.getRadius(), y);
   while (window.isOpen()) {
      // Ereignisse abfragen
      sf::Event event;
      while (window.pollEvent(event)) {
         // ggf. Fenster schließen
        if (event.type == sf::Event::Closed) {
            window.close();
        }
      }
      window.clear(sf::Color::White); // ohne Param.: Black
      // hier alles zeichnen:
      window.draw(kreis);
      window.draw(text);
      window.display();
   }
}
