#include "baumzeichnen.h"
#include <cmath>

namespace {                      // anonym
  void astzeichnen(sf::RenderWindow& w,
                   unsigned int iterationen, 
                   const sf::Vector2f& startpunkt,
                   float laenge, float breite, 
                   float winkel) {
    if(iterationen > 0) {      // noch etwas zu tun?
      if(breite < 1.0f) {      // Mindestbreite garantieren
        breite = 1.0f;
      }
      sf::RectangleShape ast(sf::Vector2f(breite, 
           -laenge));  // negativ, weil y nach unten größer wird.
      ast.setPosition(startpunkt);
      ast.rotate(winkel);
      // Der Grünanteil ist hoch, wenn nur noch wenige Iterationen
      // zu erledigen sind:
      int gruenanteil = 255-iterationen*25;
      if(gruenanteil < 0) {
        gruenanteil = 0;        // ggf. begrenzen
      }
      ast.setFillColor(sf::Color(0, gruenanteil, 0));
      w.draw(ast);
      // Endpunkt wird der neue Startpunkt:
      sf::Vector2f endpunkt = startpunkt;
      float bogenmass = winkel*3.141593f/180.0f;
      endpunkt.x += laenge * std::sin(bogenmass);
      endpunkt.y -= laenge * std::cos(bogenmass);
      --iterationen;
      // Links und rechts mit unterschiedlichen Faktoren skalieren,
      // damit der Baum nicht völlig symmetrisch wird:
      astzeichnen(w, iterationen, endpunkt, 
                  laenge * 0.8f,  breite * 0.8f,  
                  winkel + 30.0f);  // Zweig nach rechts
      astzeichnen(w, iterationen, endpunkt, 
                  laenge * 0.85f, breite * 0.8f,  
                  winkel - 22.5f);  // Zweig nach links
    }
  }
}

void baumzeichnen(unsigned int maxiterationen,
                  unsigned int periode_ms,
                  float stammlaenge) {
  sf::RenderWindow window(sf::VideoMode(sizeX, sizeY),
                          "Der Baum!");  
  sf::Time periode  = sf::milliseconds(periode_ms);
  sf::Vector2f anfangsposition(sizeX/2 + 70, sizeY); 
  unsigned int iterationen = 0;
  while (window.isOpen()) {
    sf::Event event;
    while (window.pollEvent(event)) { // Ereignisse abfragen
      if (event.type == sf::Event::Closed) { 
        window.close();
      }
    }
    if(iterationen < maxiterationen) {
      ++iterationen;
      window.clear(sf::Color::White);
      // hier alles zeichnen:
      float anfangslaenge = stammlaenge 
                            * iterationen / maxiterationen;
      astzeichnen(window, iterationen, 
                  anfangsposition, 
                  anfangslaenge,
                  0.2f*anfangslaenge,  // anfängliche Breite
                  -10.0f);        // anfänglicher Winkel
      window.display();
    }
    sf::sleep(periode);   // CPU-Zeit sparen
  }   
}
