#ifndef WUERFEL_H
#define WUERFEL_H
#include <random>

class Wuerfel {
public:
  Wuerfel()                         // Konstruktor
    : generator(rd()), verteilung(1, 6) { 
    rollen();                   // anfängliche Zahl festlegen
  }
  auto punktzahl() const {          // öffentliche Funktion
    return punktzahl_;
  }
  void rollen() {                   // öffentliche Funktion
    punktzahl_ = verteilung(generator);
  } 
private:                            // Attribute siehe Text
  std::random_device rd;
  std::mt19937 generator;
  std::uniform_int_distribution<unsigned int>
                                          verteilung;
  unsigned int punktzahl_;
};
#endif
