#include <cstddef>
#include <iostream>
#include <vector>
#include "../spieler.h"                // Oberverzeichnis
#include "wuerfel.h"
using namespace std;

int main() {
  cout << "Wieviele Spieler: ";
  size_t anzahlSpieler;
  cin >> anzahlSpieler;
  cout << "Wieviele Runden: ";
  size_t anzahlRunden;
  cin >> anzahlRunden;
  vector<Spieler> dieSpieler;
  for(size_t i = 0; i < anzahlSpieler; ++i) {
    dieSpieler.push_back(
                 Spieler("Spieler" + to_string(i+1)));
  }
  Wuerfel wuerfel;
  for(size_t i = 0; i < anzahlRunden; ++i) {
    for(auto& spieler : dieSpieler) {
      cout << spieler.name() << " würfelt. Ergebnis: ";
      wuerfel.rollen();
      auto wurf = wuerfel.punktzahl();
      spieler.aenderePunktzahl(wurf);
      cout << wurf << '\n';
    }
  }
  // Punkte anzeigen, dabei die maximale Punktzahl ermitteln
  int maxPunkte = dieSpieler[0].punktzahl();
  for(const Spieler& spieler : dieSpieler) {
    cout << spieler.name() << " hat " 
         << spieler.punktzahl() << " Punkte.\n";
    if(spieler.punktzahl() >  maxPunkte) {
      maxPunkte = spieler.punktzahl();
    }
  }
  cout << "Ende des Spiels. Gewinner: ";
  // Alle anzeigen, die die maximale Punktzahl haben:
  for(const Spieler& spieler : dieSpieler) {
    if(spieler.punktzahl() == maxPunkte) {
      cout << spieler.name() << " ";
    }
  } 
  cout << '\n';
}
