#ifndef SPIELER_H
#define SPIELER_H
#include <iostream>
#include <string>

class Spieler {
public:
  explicit Spieler(const std::string& n) 
    : name_(n), punktzahl_(0) {
  }

  Spieler(const Spieler& s)    // Kopierkonstruktor
    : name_(s.name_), punktzahl_(s.punktzahl_) {
    std::cout << "Kopierkonstruktor für "
              << name_ << " aufgerufen!\n";
  }

  const std::string& name() const {
    return name_;
  }
  int punktzahl() const {
    return punktzahl_;
  }
  void aenderePunktzahl(int differenz) {
    punktzahl_ += differenz;
  } 
  ~Spieler() {
    std::cout << name_ << " sagt: 'Ade, grausame Welt!'\n";
  }
private:
  std::string name_;
  int punktzahl_;
};
#endif
