#include "tictactoe.h"
#include <cassert>
#include <iostream>
#include <string>
using namespace std;

namespace {
bool zeileMitGleichenWerten(size_t z, const Spielfeldtyp& m) {
  assert(m.size() == 3);  // ggf. Funktion anpassen!
  return m[z][0] != leerzeichen && m[z][0] == m[z][1] &&
         m[z][1] == m[z][2];
}

bool spalteMitGleichenWerten(size_t s, const Spielfeldtyp& m) {
  assert(m.size() == 3);  // ggf. Funktion anpassen!
  return m[0][s] != leerzeichen && m[0][s] == m[1][s] &&
         m[1][s] == m[2][s];
}

bool diagonaleMitGleichenWerten(const Spielfeldtyp& m) {
  assert(m.size() == 3);  // ggf. Funktion anpassen!
  // von links oben nach rechts unten
  return (m[0][0] != leerzeichen && m[0][0] == m[1][1] &&
          m[1][1] == m[2][2]) 
          ||     // oder: von links unten nach rechts oben
         (m[2][0] != leerzeichen && m[2][0] == m[1][1] &&
          m[1][1] == m[0][2]);
}
}

void ausgabe(const Spielfeldtyp& feld) {
  size_t nr = 1;
  for (const auto& zeile : feld) {
    cout << nr++ << " |";
    for (auto wert : zeile) {
      cout << wert << '|';
    }
    cout << '\n';
  }
}

void markierungSetzen(size_t aktiv, Spielfeldtyp& feld) {
  bool fehlerhafteEingabe = true;
  cout << "Koordinateneingabe. "
          "Format z.B. 12 = Zeile 1, Spalte 2\n";
  char zeichenFuerSpieler = (aktiv == 1) ? 'x' : 'o';
  do {
    cout << "Spieler " << aktiv << " (" 
         << zeichenFuerSpieler << ") : ";
    string eingabe;
    getline(cin, eingabe);
    if (eingabe.length() >= 2) {
      // -'0' : Umrechnung von ASCII-Ziffer nach int
      // -1, weil die Zählung im Array ab 0 beginnt
      size_t z = eingabe.at(0) - '0' - 1;       // Zeile
      size_t s = eingabe.at(1) - '0' - 1;       // Spalte
      if (z < feld.size() && s < feld.size()) { // erlaubte Werte
        if (feld[z][s] != leerzeichen) {
          cout << "Position ist schon belegt! ";
        } else { // eintragen
          feld[z][s] = zeichenFuerSpieler;
          fehlerhafteEingabe = false;
        }
      }
    }
    if (fehlerhafteEingabe) {
      cout << "Fehlerhafte Eingabe!\n";
    }
  } while (fehlerhafteEingabe);
}

bool gewonnen(const Spielfeldtyp& m) {
  for (size_t z = 0; z < m.size(); ++z) { // alle Zeilen
    if (zeileMitGleichenWerten(z, m)) {   //  gefunden
      return true;   // weitere Tests unnötig
    }
  }
  for (size_t s = 0; s < m.size(); ++s) { // alle Spalten
    if (spalteMitGleichenWerten(s, m)) {  // gefunden
      return true;   // weitere Tests unnötig
    }
  }
  return diagonaleMitGleichenWerten(m);
}
