#include <cstddef>
#include <iostream>

std::size_t stellenIterativ(std::size_t zahl) {
  std::size_t anzahl = 1;
  while(zahl > 9) {
    ++anzahl;
    zahl /= 10;
  }
  return anzahl;
}
// Kurzform
std::size_t stellenRekursiv(std::size_t zahl) {
  std::size_t anzahl = 1;
  if(zahl > 9) {
    anzahl = 1 + stellenRekursiv(zahl/10);
  }
  return anzahl;
}

/* Langform
std::size_t stellenRekursiv(std::size_t zahl) {
  std::size_t anzahl = 1;
  if(zahl < 10) {
    return anzahl;
  } 
  else  {
    return 1 + stellenRekursiv(zahl/10);
  }
}
*/

using namespace std;

int main() {
  cout << "Iterativ:\n";
  std::size_t zahl = 0;
  for(int i = 1; i < 5; ++i) {
    cout << zahl << " hat " 
         << stellenIterativ(zahl) << " Stelle(n)\n";
    zahl = zahl * 10 + i;
  }
  cout << "Rekursiv:\n";
  zahl = 0;
  for(int i = 1; i < 5; ++i) {
    cout << zahl << " hat " 
         << stellenRekursiv(zahl) << " Stelle(n)\n";
    zahl = zahl * 10 + i;
  }
}
