#include <fstream>
#include <iostream>
#include <string>
using namespace std;

int main() {
  const string dateiname {"spieler.txt"};
  ifstream quelle(dateiname);   // Objekt für Eingabestrom
  if (!quelle.good()) {         // Fehlerabfrage
    cerr << dateiname 
         << " kann nicht geöffnet werden!\n";
    return 1;                   // ungleich 0 bedeutet Fehler
  }
  unsigned int punktsumme = 0;
  while (quelle.good()) {
    string zeile;
    getline(quelle, zeile);
    if(zeile.at(0) == '#' || !quelle.good()) {
      break;        // nichts mehr zu lesen: Abbruch der Schleife
    }
    cout << "Spieler " << zeile << " registriert. ";
    getline(quelle, zeile);
    // Es folgt die Umwandlung des Strings in eine Zahl:
    auto punktzahl = stoul(zeile);
    cout << "Punktzahl " << punktzahl << '\n';
    punktsumme += punktzahl;
  }
  cout << "Summe aller Punkte = " << punktsumme << '\n';
  return 0;
}
