#include <fstream>
#include <iostream>
#include <string>
using namespace std;

int main() {
  string dateiname;
  cout << "Datei? ";
  cin >> dateiname;
  ifstream datei(dateiname, ios::binary);  // siehe Text
  if (!datei.good()) {                   // Fehlerabfrage
    cerr << dateiname 
         << " kann nicht geöffnet werden!\n";
  } 
  else {
    cout << hex;        // Hexadezimaldarstellung einschalten
    constexpr unsigned int zeichenProZeile = 20;
    unsigned int zeichenzahl = 0;
    while (datei.good()) {
      char byte;
      datei.get(byte);
      // Typumwandlungen, um negative Werte bei \tts{signed char} 
      // zu vermeiden:
      const unsigned char c = 
                    static_cast<unsigned char>(byte);
      // Typumwandlung in eine Zahl:
      auto zahl = static_cast<unsigned int>(c);
      if(zahl <= 0x0f) {    // Falls die Zahl einstellig wird.
        cout << 0;  // Sonst würde nur 1 Zeichen ausgegeben.
      }
      cout << zahl << ' ';
      ++zeichenzahl;
      if (zeichenzahl == zeichenProZeile) {
        zeichenzahl = 0;    // zurücksetzen
        cout << '\n';       // neue Zeile zur Formatierung
      }
    }
    cout << '\n';
  }
}
