#ifndef MEINSTACK_H
#define MEINSTACK_H
#include <stdexcept>
#include <vector>

template<typename T>
class MeinStack {
public:
  auto empty() const { return vec.empty(); }  
  auto size() const { return vec.size(); }
  void clear() { vec.clear(); }  // Stack leeren

  void push(const T &x) {        // \tts{x} auf den Stack legen
    vec.push_back(x);
  }

  const T& top() const {       // letztes Element zurückgeben
    check();                 // Vorbedingung: Stack ist nicht leer
    return vec.back();
  }

  void pop() {                   // Element entfernen
    check();                 // Vorbedingung: Stack ist nicht leer
    vec.pop_back();
  }
private:
  void check() const {
    if(vec.empty()) {
      throw std::runtime_error("Stack ist leer!");
    }
  }
  std::vector<T> vec;            // Speicher
};
#endif
