#include <algorithm>
#include <iostream>
#include <vector>
#include "kleiner.h"

template<typename T, typename V>
void sortieren(std::vector<T>& v, const V& vergleich) {
   bool vertauscht;
   do {
      vertauscht = false;
      for(std::size_t j = 1; j < v.size(); j++) {
        if(vergleich(v[j], v[j-1])) {  // ggf. vertauschen
            int temp     = v[j-1];
            v[j-1] = v[j];
            v[j]   = temp;
            vertauscht = true;
         }
      }
   } while(vertauscht);                // \tts{false} = keine Vertauschung mehr
}
using namespace std;

int main() {
  vector<int> vec {9, -7, -5, -9, 6, 5, 1};
  cout << "Sortieren nach dem Absolutbetrag mit Lambda-Funktion: ";
  sortieren(vec, [](auto a, auto b){ return abs(a) < abs(b);});
  for(auto wert : vec) {
    cout << wert << ' ';
  }
  cout << '\n';
  // dito für die Standardfunktion sort()
  sort(vec.begin(), vec.end(),
     [](auto a, auto b){ return abs(a) < abs(b);});
  for(auto wert : vec) {
    cout << wert << ' ';
  }
  cout << '\n';

}
