#ifndef KLEINER_H
#define KLEINER_H
#include <cmath>                   // \tts{abs()}

template<typename T>
class Kleiner {
public:
  Kleiner() = default;             // siehe Text
  Kleiner(bool absbetr)
    : absolutbetrag(absbetr) {
  }
  bool operator()(const T& a, const T& b) const {
    if(absolutbetrag) {
      return std::abs(a) < std::abs(b);
    }
    else {
      return a < b;
    }
  }
private:
  bool absolutbetrag = false;
};
#endif
