#include <numeric>
#include <vector>
#include <cmath>              // wegen Quadratwurzel \tts{sqrt()}
#include <iostream>
using namespace std;

int main() {
  vector<float> punkt1 {800.0f, 600.0f};
  cout << "Entfernung vom Nullpunkt = "
       << sqrt(inner_product(punkt1.begin(), 
                punkt1.end(), punkt1.begin(), 0.0)) 
       << '\n';
  // Um die Anwendung anderer mathematischer Operatoren zu zeigen,
  // wird im Folgenden die Entfernung zwischen \tts{punkt1} und einem
  // weiteren  Punkt \tts{punkt2} berechnet.
  vector<float> punkt2  {400.0f, 300.0f};
  cout << "Entfernung zwischen punkt1 und punkt2 = "
                       // Die Entfernung ist die Quadratwurzel ...
       << sqrt(inner_product(punkt1.begin(), 
               punkt1.end(), punkt2.begin(), 0.0,
               plus<float>(), // ... der Summe 
                              // ... der Quadrate der Differenzen.
               [](auto x, auto y) { // Lambda-Funktion
                      auto d = x - y;
                      return d * d; })) << '\n';
}
