#include <iostream>
#include <iterator>                  // \tts{distance()}
#include <list>
// eigener Algorithmus finde() als Demo-Ersatz für find()
template<typename Iterator, typename T>
Iterator finde(Iterator anfang, Iterator ende, const T& gesucht) {
  while(anfang != ende) {
    if(*anfang == gesucht) {
      return anfang;
    }
    ++anfang;
  }
  return ende;
}
using namespace std;

int main() {
  list<string> container { "Pac-Man", "Tetris", "Doom"};
  const string gesucht = "Doom";
  auto position = finde(container.begin(), container.end(),
                        gesucht);
  if(position != container.end()) {
    cout << *position << " gefunden! Position " 
         << distance(position, container.begin()) << '\n';
  }
  else {
    cout << gesucht << " wurde nicht gefunden\n";
  }
}
