#include <iostream>
#include <complex> // Header für komplexe Zahlen
constexpr double pi = 3.14159265358979324;
using namespace std;

int main() {
  complex<double> c1;           // komplexe Zahl 0.0 + 0.0{\it i}
  complex<double> c2(1.2, 3.4); // (1.2 + 3.4{\it i}) erzeugen
  cout << c2 << '\n';       // Standard-Ausgabeformat: (1.2,3.4)
  c1 += c2 + c1;            // beispielhafte Rechenoperationen
  c1 = c2 * 5.0;
  double re = c1.real();     // Realteil ermitteln
  cout << re << '\n';        // und ausgeben
  cout << c1.imag() << '\n'; // Imaginärteil direkt ausgeben
  // Beispiele mit Hilfsfunktionen
  complex<double> c3 = {1.0, 2.0}; // (1.0 + 2.0{\it i}) erzeugen
  c1 = conj(c3);               // konjugiert komplex: (1.0 - 2.0{\it i})
  // Umrechnung aus Polarkoordinaten
  double betrag = 100.0;
  double phase = pi / 4.0;      // $\pi/4 = 45^\circ$
  c1 = polar(betrag, phase);
  // Umrechnung in Polarkoordinaten
  cout << "\nBetrag : " << abs(c1)
       << "\nWinkel (Bogenmaß): " << arg(c1)
       << "\nWinkel (Grad): " << arg(c1)*180./pi
       << "\nBetragsquadrat : " << norm(c1) << '\n';
  // Erzeugung imaginärer Zahlen (Realteil ist 0) mit Suffix i
  complex<double> imaginaer{3.7i};
  cout << "imaginaere Zahl = " << imaginaer << '\n';
}
