#include <iostream>
#include <vector>
#include "observerptr.h"
#include "../kap6/wuerfel/wuerfel.h"

int main() {
  Wuerfel w1;
  Wuerfel w2;
  Wuerfel w3;
  // &w ist die Adresse des Objekts w:
  std::vector<ObserverPtr> dieWuerfel { &w1, &w2, &w3};
  for(auto ptr : dieWuerfel) {
    ptr->rollen();              // operator->()
    std::cout << (*ptr).punktzahl() << '\n'; // operator*()
  }
  ObserverPtr o1(&w1);
  ObserverPtr o2(&w1);
  if(o1 == o2) {                 // operator==()
    std::cout << "gleich\n";
  }
  else {
    std::cout << "ungleich\n";
  }
  if(o1) {                       // operator bool()
    std::cout << "true, d.h. != nullptr\n";
  }
  o1.release();       // enthält jetzt nullptr
  o1->rollen();     // Exception provozieren 
}
