#ifndef OBSERVERPTR_H
#define OBSERVERPTR_H
#include <stdexcept>

class Wuerfel;         // Vorwärtsdeklaration

class ObserverPtr {
public:
  ObserverPtr(Wuerfel* bptr = nullptr) 
    : bp(bptr) {
  }
  explicit operator bool() const {
    return bp != nullptr; 
  }
  Wuerfel* get() const { 
    return bp;   // rohen Zeiger zurückgeben
  }
  Wuerfel* release()  { // freigeben
    Wuerfel* temp = bp;
    bp = nullptr;
    return temp; 
  }
  Wuerfel* operator->() const { 
    check();
    return bp;  // rohen Zeiger geprüft zurückgeben
  }
  Wuerfel& operator*() const { 
    check();
    return *bp; 
  }
private:
  Wuerfel* bp;
  void check() const {
    if(bp == nullptr) {
      throw std::runtime_error("Nullpointer exception!");
    }
  }
};

bool operator==(ObserverPtr a, ObserverPtr b) {
  return a.operator->() == b.operator->();
}

bool operator!=(ObserverPtr a, ObserverPtr b) {
  return !(a == b);
}

#endif
