#ifndef MINISTRING_H
#define MINISTRING_H
#include <cstring>         //  \tts{strlen()}, \tts{strcpy()}
#include <utility>         // \tts{swap()}

class MiniString {
public:
  MiniString(const char* str = "")   // Konstruktor
    : anzahl(std::strlen(str)),
      ptr(new char[anzahl+1]) {
    strcpy(ptr, str);
  } 
  MiniString(const MiniString& m)    // Kopierkonstruktor
    : anzahl(m.anzahl),
      ptr(new char[anzahl+1]) {
    strcpy(ptr, m.ptr);
  }
  ~MiniString() {  delete [] ptr;  }    // Destruktor
  MiniString& operator=(MiniString m) { // Zuweisungsop.
    swap(m);
    return *this;
  }
  void swap(MiniString& m) {
    std::swap(anzahl, m.anzahl);
    std::swap(ptr, m.ptr);
  }
  const char* c_str() const {  return ptr;  }
private:
  std::size_t anzahl;
  char* ptr;
};
#endif
