#include "cstringiterator.h"  // enthält \tts{\#include <iostream>}

int main() {
  CStringIterator text("read-only-Text");
  CStringIterator str(text);           // Arbeitskopie
  std::cout << "zeichenweise ausgeben, Präfix ++: ";
  while(*str) {                        // \tts{operator*()}
    std::cout << *str << ' ';
    ++str;
  }
  str = text;                       // auf Anfang zurücksetzen
  std::cout << "\nzeichenweise ausgeben, Postfix ++: ";
  while(*str) {
    std::cout << *str++ << '.';     // Operatoren \tts{*} und \tts{++} 
  }
  std::cout << "\nzeichenweise rückwärts ausgeben, "
               "Präfix --: ";
  while(str != text) {              // \tts{operator!=()}
    std::cout << *--str << ' ';     // Operatoren \tts{*} und \tts{-{}-} 
  }
  std::cout << "\nStringlänge berechnen: ";
  str = text;                       // auf Anfang zurücksetzen
  while(*str++);
  auto laenge = str - text - 1;     //  \tts{operator-()}
  std::cout << laenge << '\n';
  if(str) {                         //  \tts{operator bool()}
    std::cout << "Iterator ist gültig.\n";
  }
  std::cout << "Ausgabe mit <<: " 
            << text << '\n';        //   \tts{operator<{}<()}
}
