#ifndef CSTRINGITERATOR_H
#define CSTRINGITERATOR_H
#include <iostream>
using Beobachtet = const char; // neuer Name in Anlehnung an
                               // den beobachtenden Zeiger.
class CStringIterator {
public:
  constexpr CStringIterator(Beobachtet* cptr = nullptr) 
    : cp(cptr) {
  }

  constexpr explicit operator bool() const {
    return cp != nullptr; 
  }

  constexpr Beobachtet* get() const { 
    return cp;  // rohen Zeiger zurückgeben
  }

  constexpr Beobachtet* operator->() const { // dito mit Operator
    return cp;  // rohen Zeiger zurückgeben
  }

  constexpr Beobachtet& operator*() const { 
    return *cp; 
  }

  constexpr CStringIterator& operator++() { 
    ++cp;
    return *this; 
  }

  constexpr CStringIterator operator++(int) { 
    CStringIterator temp(*this);
    ++*this;
    return temp; 
  }

  constexpr CStringIterator& operator--() { 
    --cp;
    return *this; 
  }

  constexpr CStringIterator operator--(int) { 
    CStringIterator temp(*this);
    --*this;
    return temp; 
  }
private:
  Beobachtet* cp;
};

// globale Funktionen
constexpr bool operator==(CStringIterator a, 
                          CStringIterator b) {
   return a.get() == b.get();
}

constexpr bool operator!=(CStringIterator a, 
                          CStringIterator b) {
  return !(a == b);
}

constexpr auto operator-(CStringIterator a, 
                         CStringIterator b) {
  return a.get() - b.get();
}

inline std::ostream& operator<<(std::ostream& ausgabe,
                                CStringIterator cstri) {
  return ausgabe << cstri.get();
}
#endif
