#ifndef FOLGE_H
#define FOLGE_H
#include <cstddef>
#include <initializer_list>
#include <iostream>
#include <stdexcept>
#include <vector>

class Folge {
public:
  Folge() = default;
  // Konstruktor für die Initialisierung mit geschweiften Klammern
  Folge(std::initializer_list<int> il) 
    : folge(il) {
  }
  std::size_t size() const { 
    return folge.size(); 
  }
  // Indexoperator
  int& operator[](std::size_t index) {
    check(index);
    return folge[index];
  }
  // const-Indexoperator
  const int& operator[](std::size_t index) const {
    check(index);
    return folge[index];
  }
  Folge& operator+=(const Folge& f) {
    for(std::size_t i  = 0; i < f.size(); ++i) {
      folge.push_back(f[i]);
    }
    return *this;
  }
  Folge& operator+=(int t) {
    folge.push_back(t);
    return *this;
  }
private:
  void check(std::size_t ind) const {
    if(ind >= size()) {
      throw std::range_error("Index zu groß!");
    }
  }
  std::vector<int> folge;
};

inline Folge operator+(Folge f1, const Folge& f2) {
  return f1 += f2;
}

inline std::ostream& operator<<(std::ostream& ausgabe, 
                                const Folge& f) {
  for(std::size_t i  = 0; i < f.size(); ++i) {
    ausgabe << f[i] << ' ';
  }
  return ausgabe;
}

#endif
