#ifndef VOGELSCH_SS_H
#define	VOGELSCH_SS_H
#include <random>
#include "Vogel.h"

class Vogelsch_ss : public sf::CircleShape {
public:
  Vogelsch_ss(std::shared_ptr<Vogel> vogel)
  : sf::CircleShape(10.0f),
    v(vogel->v()),   // anfangs dieselbe Geschwindigkeit
    angehalten(false) {
    scale(0.2f, .40f);
    setPosition(vogel->getPosition());
    move(10.0f, 30.0f); // Position relativ zum Vogel korrigieren
  }

  void positionAktualisieren() {
    if (!angehalten) {
      v.x *= 0.99f;    // nimmt ab wegen Gegenwind
      v.y += 0.4f;     // nimmt zu wegen Schwerkraft     
      move(v);
    }
  }

  bool beiKollisionAnhalten(
                  std::shared_ptr<MySprite> mysprite) {
    bool getroffen = false;
    if (!angehalten) {
      getroffen = mysprite->getroffen(getPosition());
      if (getroffen) {
        angehalten = true; // Bei einer Kollision wird die Bewegung angehalten
        setRadius(15.0f);  // Klecks vergrößern
        std::random_device rd;
        // um zufälligen Wert >>nachrutschen<<
        move(0.0f, rd() % 30);
      }
    }
    return getroffen;
  }
private:
  sf::Vector2f v;
  bool angehalten;
};
#endif	

