#ifndef VOGEL_H
#define	VOGEL_H
#include <SFML/Graphics.hpp>  
#include "../kap10/Dateifehler.h"

class Vogel : public sf::Sprite {
public:
  Vogel(sf::Vector2f position, sf::Vector2f geschw)
    : geschwindigkeit(geschw) {
    if (!texture.loadFromFile("vogel.png")) {
      throw Dateifehler("vogel.png kann nicht "
                        "geöffnet werden!\n");
    } 
    setTexture(texture);
    // \emph{vogel.png} besteht aus zwei Bildern:
    setTextureRect(frames[0]); // zunächst 1. Bild wählen
    setPosition(position);
  }

  void flieg() {
    move(geschwindigkeit);
    ++anzahlBewegungen;
    if (anzahlBewegungen == 5) { // Flügelschlag alle 5 Male
      anzahlBewegungen = 0;
      frameNr = frameNr == 0 ? 1 : 0;//  abwechselnd 0 und 1
      setTextureRect(frames[frameNr]);
    }
  }

  sf::Vector2f v() const {
    return geschwindigkeit;
  }
private:
  sf::Vector2f geschwindigkeit;
  unsigned int anzahlBewegungen = 0;
  unsigned int frameNr = 0;
  sf::Texture texture;
  // Zwei Rechtecke, angepasst an \emph{vogel.png}:
  const std::vector<sf::IntRect> frames { 
      sf::IntRect(5, 0, 63, 60),  // Bild 1
      sf::IntRect(71, 0, 63, 60)  // Bild 2
      };
};
#endif

