#ifndef SPIEL_H
#define	SPIEL_H
#include <SFML/Graphics.hpp>  
#include <SFML/Audio.hpp>  
#include <memory>
#include "Mond.h"
#include "MySprite.h"
#include "Vogel.h"
#include "Anzeige.h"

class Spiel {
public:
  Spiel(unsigned int sx, unsigned int sy)
    : window(sf::VideoMode(sx, sy), "Das Spiel"),
      periode(sf::milliseconds(25)) {
    window.setKeyRepeatEnabled(false);
    datenInitialisieren();
  }
 // Ablauf starten. Anzahl der Runden übergeben.
  void run(unsigned int anzahl);
private:
  void datenInitialisieren();
  void ereignisseVerarbeiten();
  void vogelsch_aktualisieren();
  void hintergrundAktualisieren();
  sf::RenderWindow window;
  sf::Time periode; 
  std::shared_ptr<Mond> mond;
  std::shared_ptr<MySprite> kuh;
  std::shared_ptr<MySprite> kuhkopfgedreht;
  std::shared_ptr<MySprite> wiese;
  std::shared_ptr<Anzeige> anzeige;
  std::shared_ptr<Vogel> vogel;
  unsigned int treffer = 0;
  // Mit der Hintergrundhelligkeit die Dämmerung simulieren
  float hintergrundhelligkeit = 0.0f;
  sf::SoundBuffer soundbuffer;
  sf::Sound sound;
};
#endif

