#include <algorithm>
#include <memory>
#include <vector>
#include "Spiel.h"
#include "Vogelsch.h"

namespace { // Datenbereich
  std::vector<std::shared_ptr<sf::Drawable>> 
                                            zuzeichnen;
  unsigned int tastenDruecke = 0;
  unsigned int dauerFuerGedrehtenKuhkopf = 0;
}

void Spiel::datenInitialisieren() {
  mond = std::make_shared<Mond>(60.0, 
                             sf::Vector2f(10.0, 40.0));
  wiese = std::make_shared<MySprite>("wiese.png", 
          sf::Vector2f(0.0f, window.getSize().y + 70));
  kuh = std::make_shared<MySprite>("kuh.png",
          sf::Vector2f(window.getSize().x * 0.7f, 
                       window.getSize().y));
  kuhkopfgedreht = std::make_shared<MySprite>(
               "kuhkopfgedreht.png",
               sf::Vector2f(window.getSize().x * 0.75f,
               window.getSize().y -150));
  anzeige = std::make_shared<Anzeige>(
           sf::Vector2f(20, window.getSize().y - 170));
  vogel = std::make_shared<Vogel>(
                 sf::Vector2f(0.f, 200.f),    // x, y
                 sf::Vector2f(3.0f, -0.4f)); // vx, vy
  zuzeichnen.push_back(mond);
  zuzeichnen.push_back(wiese);
  zuzeichnen.push_back(kuh);
  zuzeichnen.push_back(anzeige);
  zuzeichnen.push_back(vogel);
  if(!soundbuffer.loadFromFile("kuh.wav")) {
    std::cerr << "Sound wurde nicht geladen!\n"; 
  }
  else {
    sound.setBuffer(soundbuffer);
  }
}

void Spiel::run(unsigned int runde) {
  bool gameover = false;
  sf::Time dauer; // aktuell vergangene Zeit
  sf::Clock stoppuhr; // um \tts{dauer} zu ermitteln
  while (window.isOpen()) { // Hauptschleife
    dauer = stoppuhr.getElapsedTime();
    ereignisseVerarbeiten();
    if (dauer >= periode && !gameover) {
      stoppuhr.restart();
      vogel->flieg();
      // Position ggf. am Bildschirmrand zurücksetzen:
      if (vogel->getPosition().x 
             >  window.getView().getSize().x) {
        vogel->setPosition(0.0f, 200.0f);
        --runde;   // Es bleibt eine Runde weniger zu spielen.
        if (runde == 0) {
          gameover = true;
        }
      }
      vogelsch_aktualisieren();
      anzeige->updateText(gameover, treffer, 
                        tastenDruecke - treffer);
      hintergrundAktualisieren(); 
                            // enthält \tts{window.clear();}
      // Nun alles zeichnen:
      for (const auto& obj : zuzeichnen) {
        window.draw(*obj);
      }
      window.display();
      if(dauerFuerGedrehtenKuhkopf == 0) {
        // gedrehten Kuhkopf nach gegebener Zeit wieder löschen
        auto kuhkopfposition = std::find(
                zuzeichnen.begin(), zuzeichnen.end(),
                kuhkopfgedreht);
        if (kuhkopfposition != zuzeichnen.end()) {
          zuzeichnen.erase(kuhkopfposition);
        }
      }
      else {
        --dauerFuerGedrehtenKuhkopf;       
      }
    }
  }
}

void Spiel::ereignisseVerarbeiten() {
  sf::Event event;
  while (window.pollEvent(event)) {
    switch (event.type) {
      case sf::Event::Closed: window.close();
        break;
      case sf::Event::KeyPressed:
        if (event.key.code == sf::Keyboard::Space) {
          // \tts{Vogelsch\_ss} hinzufügen
          zuzeichnen.push_back(
                 std::make_shared<Vogelsch_ss>(vogel));
          ++tastenDruecke;
        }
        break;
      default:  ; // nichts tun
    }
  }
}

void Spiel::vogelsch_aktualisieren() {
  // Position nur bei den \tts{Vogelsch\_ss}-Objekten aktualisieren
  for (auto& obj : zuzeichnen) {
    auto vs = std::dynamic_pointer_cast
                                    <Vogelsch_ss>(obj);
    if (vs) {
      vs->positionAktualisieren();
      vs->beiKollisionAnhalten(wiese);
      if (vs->beiKollisionAnhalten(kuh)) {
        ++treffer;
        sound.play();
        zuzeichnen.push_back(kuhkopfgedreht);
        dauerFuerGedrehtenKuhkopf = 25;
      }
    }
  }
}

void Spiel::hintergrundAktualisieren() {
  auto h = static_cast<unsigned char> 
                           (hintergrundhelligkeit);
  window.clear(sf::Color(h, h, h, 255));
  if (hintergrundhelligkeit < 255.0f) {
    // Die Nacht geht, der Tag kommt:
    hintergrundhelligkeit += 0.1f;
  }
  // der Mond geht langsam unter und verblasst:
  mond->sinkt(sf::Vector2f(0.1f, 0.15f), h);
}
