#ifndef MYSPRITE_H
#define	MYSPRITE_H
#include <string>  
#include <SFML/Graphics.hpp>  
#include "../kap10/Dateifehler.h"

class MySprite : public sf::Sprite {
public:
  MySprite(const char* datei, sf::Vector2f position) {
    if (!texture.loadFromFile(datei)) {
      throw Dateifehler(std::string(datei) 
                        + " kann nicht geöffnet werden!\n");
    } 
    setTexture(texture);
    // Positionskorrektur um Texturhöhe
    position.y -= texture.getSize().y; 
    image = texture.copyToImage();
    setPosition(position);
  }

  bool getroffen(sf::Vector2f pos) {
    if (getGlobalBounds().contains(pos)) { 
                             // Sicherheitsabfrage
      // Umrechnung auf Image-Koordinaten
      pos.x -= getPosition().x;
      pos.y -= getPosition().y;
      // Kriterium: Pixel mit alpha != 0;
      return image.getPixel(pos.x,pos.y).a != 0;
    }    
   return false;
  }
private:
  sf::Texture texture;
  sf::Image image;
};
#endif

