#ifndef ANZEIGE_H
#define	ANZEIGE_H
#include <SFML/Graphics.hpp>  
#include <iostream>
#include "../kap7/fonts.h"

class Anzeige : public sf::Text {
public:
  Anzeige(sf::Vector2f position) {
    if (!font.loadFromFile(ArialFontDatei)) {
      std::cerr << "Font nicht gefunden\n";
    }
    setFont(font);
    setCharacterSize(20);
    updateText(false, 0, 0);      // siehe unten
    setFillColor(sf::Color::White);
    setPosition(position);
  }
  
  void updateText(bool gameover, unsigned int treffer, 
                  unsigned int patzer) {
    std::string text = "getroffen: ";
    text += std::to_string(treffer);
    if (gameover) {
      text += "   Game over!";
      setFillColor(sf::Color::Red);
    }
    text += "\ndaneben : " + std::to_string(patzer);
    setString(text);
  }
private:
  sf::Font font;
};
#endif

