#include <iostream>
#include <exception>                   // \tts{exception}
#include <stdexcept>                   // \tts{runtime\_error}

// Test verschiedener Exception-Arten

int main() {
  std::cout << "Bitte Exception-Art wählen:\n"
    "0 : exception\n"
    "1 : runtime_error\n"
    "2 : const char*\n"
    "3 : andere Art (int) :";
  int art;
  std::cin >> art;
  try {
    switch(art) {
       case 0 : throw std::exception();
       case 1 : throw std::runtime_error("RT-Fehler!");
       case 2 : throw "char: Fehlermeldung!";
       default : throw 42;
    }
  }
  catch(const std::runtime_error& e) {
    std::cout << "runtime_error: " << e.what() << '\n';
  }
  catch(const std::exception& e) {
    std::cout << "exception aufgefangen.\n";
  }
  catch(const char* e) {
    std::cout << "const char* : " << e << '\n';
  }
  catch(...) {
    std::cout << "Andere Exception aufgefangen.\n";
    throw;       // weiterleiten an die nächste Ebene
  }
}
