// wie exc1.cpp, aber mit den Makros __FILE__ und __LINE__
#include <iostream>
#include <stdexcept>                   // \tts{runtime\_error}

double bruchAlsDouble(long int zaehler, 
                      long int nenner) {
  if(nenner == 0L) {   // ganzzahlige Division verhindern
    throw std::runtime_error(std::string(__FILE__ " Zeile ") 
                        + std::to_string(__LINE__) + ": Nenner ist 0!");
  }
  return static_cast<double>(zaehler)/nenner;
}

int main() {
  // Berechnung von Zähler und Nenner, hier der Einfachheit
  // halber als Konstante festgelegt:
  const long int zaehler = 356789L;
  const long int nenner = 0L;
  try {
    double ergebnis = bruchAlsDouble(zaehler, nenner);
    std::cout << ergebnis << '\n';
  }
  catch(const std::runtime_error& err) {
    std::cerr << err.what() 
              << " Nicht behebbarer Fehler\n";
  }
}
