#include <fstream>
#include <iostream>
#include <string>
#include "Dateifehler.h"

void dateiverarbeiten(const std::string& name) {
  std::ifstream datei(name);
  if(datei.good()) {
    std::cout << name << " wird verarbeitet ...\n"; 
  }
  else {
    throw Dateifehler(name + 
           " kann nicht geöffnet werden!\n");
  }
}

int main() {
  try {
    dateiverarbeiten("dateitest.cpp");
    dateiverarbeiten("dateiexistiertnicht.txt");
    // weitere weggelassen ...
  }
  catch(const Dateifehler& exc) {
    std::cerr << exc.what() 
              << "Weiterverarbeitung zwecklos. Stop!\n";
  }
  catch(const std::runtime_error& rt) {
    std::cerr << rt.what() 
              << "Anderer runtime_error. Stop!\n";
  }
}
